<?php
/**
 * Copyright (C) 2018    Andreu Bisquerra    <jove@bisquerra.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

/**
 *	\file       htdocs/takepos/invoice.php
 *	\ingroup    takepos
 *	\brief      Page to generate section with list of lines
 */

// if (! defined('NOREQUIREUSER'))    define('NOREQUIREUSER', '1');    // Not disabled cause need to load personalized language
// if (! defined('NOREQUIREDB'))        define('NOREQUIREDB', '1');        // Not disabled cause need to load personalized language
// if (! defined('NOREQUIRESOC'))        define('NOREQUIRESOC', '1');
// if (! defined('NOREQUIRETRAN'))        define('NOREQUIRETRAN', '1');
if (!defined('NOCSRFCHECK')) { define('NOCSRFCHECK', '1'); }
if (!defined('NOTOKENRENEWAL')) { define('NOTOKENRENEWAL', '1'); }
if (!defined('NOREQUIREMENU')) { define('NOREQUIREMENU', '1'); }
if (!defined('NOREQUIREHTML')) { define('NOREQUIREHTML', '1'); }
if (!defined('NOREQUIREAJAX')) { define('NOREQUIREAJAX', '1'); }

// Try main.inc.php using relative path
$res=0;
if (!$res && file_exists("../main.inc.php")) $res = @include "../main.inc.php";
if (!$res && file_exists("../../main.inc.php")) $res = @include "../../main.inc.php";
if (!$res && file_exists("../../../main.inc.php")) $res = @include "../../../main.inc.php";
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';

global $mysoc;

$langs->loadLangs(array("companies", "commercial", "bills", "cashdesk", "stocks", "banks"));
$langs->loadLangs(array("takepossaveas@takepossaveas"));

$place = (GETPOST('place', 'aZ09') ? GETPOST('place', 'aZ09') : 0); // $place is id of table for Bar or Restaurant
$placeid = 0; // $placeid is ID of invoice
$type = GETPOST('type');
// Terminal is stored into $_SESSION["takeposterminal"];

if (empty($user->rights->takepos->run) && !defined('INCLUDE_PHONEPAGE_FROM_PUBLIC_PAGE')) {
	accessforbidden();
}



/**
 * Abort invoice creationg with a given error message
 *
 * @param   string  $message        Message explaining the error to the user
 * @return	void
 */
function fail($message)
{
	header($_SERVER['SERVER_PROTOCOL'].' 500 Internal Server Error', true, 500);
	die($message);
}



$number = GETPOST('number', 'alpha');
$idline = GETPOST('idline', 'int');
$selectedline = GETPOST('selectedline', 'int');
$desc = GETPOST('desc', 'alphanohtml');
$pay = GETPOST('pay', 'aZ09');
$amountofpayment = price2num(GETPOST('amount', 'alpha'));

$invoiceid = GETPOST('invoiceid', 'int');

$paycode = $pay;
if ($pay == 'cash')   $paycode = 'LIQ'; // For backward compatibility
if ($pay == 'card')   $paycode = 'CB'; // For backward compatibility
if ($pay == 'cheque') $paycode = 'CHQ'; // For backward compatibility

// Retrieve paiementid
$sql = "SELECT id FROM ".MAIN_DB_PREFIX."c_paiement";
$sql .= " WHERE entity IN (".getEntity('c_paiement').")";
$sql .= " AND code = '".$db->escape($paycode)."'";
$resql = $db->query($sql);
$obj = $db->fetch_object($resql);
$paiementid = $obj->id;

$invoice = new Facture($db);
if ($invoiceid > 0)
{
	$ret = $invoice->fetch($invoiceid);
} else {
	$ret = $invoice->fetch('', '(PROV-POS'.$_SESSION["takeposterminal"].'-'.$place.')');
}
if ($ret > 0)
{
	$placeid = $invoice->id;
}






$constforcompanyid = 'CASHDESK_ID_THIRDPARTY'.$_SESSION["takeposterminal"];

$soc = new Societe($db);
if ($invoice->socid > 0) $soc->fetch($invoice->socid);
else $soc->fetch($conf->global->$constforcompanyid);





if ($type=='order'){
	require_once DOL_DOCUMENT_ROOT.'/commande/class/commande.class.php';
	$object = new Commande($db);
	$object->socid=$invoice->socid;
	$object->date=dol_now();
	foreach ($invoice->lines as $line) {
		$orderline=new OrderLine($db);
		$orderline->fk_product=$line->fk_product;
		$orderline->tva_tx=$line->tva_tx;
		$orderline->remise_percent=$line->remise_percent;
		$orderline->qty=$line->qty;
		$orderline->total_ht=$line->total_ht;
		$orderline->total_tva=$line->total_tva;
		$orderline->total_ttc=$line->total_ttc;
		$orderline->price=$line->price;
		$orderline->subprice=$line->subprice;
		$orderline->desc=$line->desc;
		$orderline->description=$line->description;
		$object->lines[]=$orderline;
	}
	$id=$object->create($user);
	$object->valid($user);
}

if ($type=='proposal'){
	require_once DOL_DOCUMENT_ROOT.'/comm/propal/class/propal.class.php';
	$object = new Propal($db);
	$object->socid=$invoice->socid;
	$object->date=dol_now();
	foreach ($invoice->lines as $line) {
		$orderline=new PropaleLigne($db);
		$orderline->fk_product=$line->fk_product;
		$orderline->tva_tx=$line->tva_tx;
		$orderline->remise_percent=$line->remise_percent;
		$orderline->qty=$line->qty;
		$orderline->total_ht=$line->total_ht;
		$orderline->total_tva=$line->total_tva;
		$orderline->total_ttc=$line->total_ttc;
		$orderline->price=$line->price;
		$orderline->subprice=$line->subprice;
		$orderline->desc=$line->desc;
		$orderline->description=$line->description;
		$object->lines[]=$orderline;
	}
	$id=$object->create($user);
	$object->valid($user);
}

$i = 0;
$times_to_run = 200;
$array = array();
while ($i++ < $times_to_run)
{
    $sql = "SELECT rowid FROM ".MAIN_DB_PREFIX."facturedet where fk_facture = ".((int) $placeid)." ORDER BY rowid DESC";
	$resql = $db->query($sql);
	$row = $db->fetch_array($resql);
	$deletelineid = $row[0];
	if ($deletelineid<1) break;
	$invoice->deleteline($deletelineid);
	$invoice->fetch($placeid);
}


require_once DOL_DOCUMENT_ROOT . '/core/class/html.form.class.php';
 // Title
$title='TakePOS - Dolibarr '.DOL_VERSION;
if (! empty($conf->global->MAIN_APPLICATION_TITLE)) $title='TakePOS - '.$conf->global->MAIN_APPLICATION_TITLE;
$head='<meta name="apple-mobile-web-app-title" content="TakePOS"/>
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="mobile-web-app-capable" content="yes">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>';
top_htmlhead($head, $title, $disablejs, $disablehead, $arrayofjs, $arrayofcss);

$form = new Form($db);

?>
<script language="javascript">

function OpenOrder(id){
	window.open(
	<?php if ($type=="order"){
	?>
  '../../commande/card.php?id='+id,
	<?php
	}
	else{
	?>
  '../../comm/propal/card.php?id='+id,
	<?php
	}
	?>
);

}
</script>
<?php

print '<div class="div-table-responsive-no-min invoice">';
print '<table id="tablelines" class="noborder noshadow postablelines" width="100%">';
print '<tr class="liste_titre nodrag nodrop">';
print '<td class="linecoldescription">';
print '<span style="font-size:120%;" class="right">';

print $langs->trans('Order');
print '</span>';
print '</td>';
print "</tr>\n";

print '<tr class="drag drop oddeven posinvoiceline">';
print '<td onclick="ChangeSerie(' . $row['rowid'] . ')" class="center"><h1>';
if ($type=='order') echo $langs->trans('SavedAsOrder')."";
else echo $langs->trans('SavedAsProposal')."";
echo '</h1></td>';
print '</tr>'."\n";

print '</table>';
print '<center>';
print '<button type="button" onclick="OpenOrder('.$id.');"><h2>'.$langs->trans('Show').'</h2></button>';
print '</div>';



?>